﻿$prefix = "soka\"  # 固定の接頭辞

# ホスト名のリスト
$hostNames = @(
    "svpr11.soka.ac.jp",
    "svpr12.soka.ac.jp",
    "svpr13.soka.ac.jp",
    "svpr14.soka.ac.jp"
)

# 入力と確認をループ
while ($true) {
    # ユーザー名とパスワードの入力
    $userInput = Read-Host "ユーザー名（eまたはwから始まるもの）"
    $userName = $prefix + $userInput

    $password = Read-Host "パスワードを入力してください（パスワードが表示されます、周りに人がいないか確認してください）"

    # 入力内容の確認
    Write-Host ""
    Write-Host "入力内容を確認してください："
    Write-Host "ユーザー名 : $userName"
    Write-Host "パスワード : $password"
    Write-Host ""

    # Yes/No の確認
    Write-Host "この内容で登録しますか？"
    Write-Host "正しい場合は Y、修正する場合は N を押し、Enter を押してください。"
    $confirm = Read-Host "（Y/N）"
    if ($confirm.ToUpper() -eq "Y") {
        break  # 登録処理へ進む
    } elseif ($confirm.ToUpper() -eq "N") {
        Write-Host "再入力します。"
        continue  # ループの先頭に戻る
    } else {
        Write-Host "無効な入力です。Y または N を入力してください。"
    }
}

# 資格情報の登録
foreach ($targetHost in $hostNames) {
    cmdkey /add:$targetHost /user:$userName /pass:$password
    Write-Host "登録完了: $targetHost"
}