﻿param ( [string]$printerPath = "\svpr11.soka.ac.jp\オンデマンドプリンター" )

# ジョブとしてプリンタ追加を実行
$job = Start-Job -ScriptBlock {
    param($path)
    try {
        Add-Printer -ConnectionName $path -ErrorAction Stop
        return "Success"
    } catch {
        return "Error: $($_.Exception.Message)"
    }
} -ArgumentList $printerPath

# 最大120秒待機
$completed = Wait-Job -Job $job -Timeout 120

if ($completed) {
    $result = Receive-Job -Job $job
    if ($result -eq "Success") {
        Write-Host "プリンタの追加に成功しました：$printerPath"
        exit 0
    } else {
        Write-Host "プリンタの追加に失敗しました：$printerPath"
        Write-Host $result
        exit 1
    }
} else {
    # タイムアウト時の処理
    Stop-Job -Job $job | Out-Null
    Remove-Job -Job $job | Out-Null
    Write-Host "プリンタ追加処理がタイムアウトしました（120秒以上経過）"
    exit 2
}